function leandro_data_monthly2daily(data_bloomberg)
% --------------------------------------------------------------------------------------------------
% Using daily stock price data, convert compustat data from monthly to daily frequency
% --------------------------------------------------------------------------------------------------
% data_bloomberg      ... structure with daily stock prices and market cap
% --------------------------------------------------------------------------------------------------
% sample call: leandro_data_monthly2daily(stock_prices_bloomberg)
% --------------------------------------------------------------------------------------------------

% Determine available files
files = dir('c:/thesis/mba slides/leandro code/mats/data');
files = {files(3:end).name};
num_firms = length(files);
company_names = {data_bloomberg.ticker};

% Generate table for GFKEY - TICKER matching
[num, txt] = xlsread('c:/thesis/data/compustat/stocks cdx.xls', 1);
tickers = txt(2:end,end-1);
gvkeys = num(:,1);
new_pos = find(diff([0; gvkeys]) ~= 0);
tickers = tickers(new_pos);
gvkeys = gvkeys(new_pos);

% For each file update frequency of data (where available)
for i=1:num_firms
    % Map gvkey to ticker symbol
    pos = findstr(files{i}, '_');
    pos2 = findstr(files{i}, '.mat');
    gvkey = str2double(files{i}((pos+1):(pos2-1)));
    pos = find(gvkeys == gvkey);
    ticker = tickers{pos};

    % Import Leandro's data
    filename = ['c:/thesis/mba slides/leandro code/mats/data/' files{i}];
    load(filename);

    % Determine matching stock price data
    stock_pos = find(strcmp(company_names, ticker));
    if (isempty(stock_pos))
        continue;
    end
    stock_data = data_bloomberg(stock_pos);
    
    % Impute new data
    for j=1:length(stock_data.dates)
        % Determine position of insertion
        comp_dates = data(:,1);
        date = stock_data.dates(j);
        pos = find([comp_dates; Inf] >= date, 1, 'first');
                
        % Impute/overwrite data
        if (is_member_sorted_c(date, comp_dates))
            % Stock price
            data(pos, end-1) = stock_data.price(j);
            % Outstanding shares
            data(pos, end) = stock_data.mcap(j) / stock_data.price(j);
        else
            tmp = data(max(pos-1,1),:);
            tmp(1) = stock_data.dates(j);
            % Stock price
            tmp(end-1) = stock_data.price(j);
            % Outstanding shares
            tmp(end) = stock_data.mcap(j) / stock_data.price(j);
            data = [data(1:(pos-1),:); tmp; data(pos:end,:)];
        end  
    end
    save(filename, 'data');
end


